﻿#requires -version 2
<#

.SYNOPSIS
  Check a Fujitsu computer for driver updates

.DESCRIPTION
  Runs the ducmd.exe and search for drivers udpates. And returns a true if some is available.

.NOTES
  Version:        1.0
  Author:         Sebastian Selig
  Creation Date:  16.05.2018
  Purpose/Change: Initial script development
  
#>
# ---------------------------------------------------------------------------
# config values
# ---------------------------------------------------------------------------
$scriptPath 		= split-path -parent $MyInvocation.MyCommand.Definition
$ScriptName 		= ((Get-Variable MyInvocation).Value).MyCommand.Name
$UPDATE_REQUIRED 	= $false
$RETURN_MESSAGE 	= '';
### 				  change this to your location where ducmd.exe is hosted
$DUCMD 				= "\\BARAMUNDI\dip$\Tools\DeskUpdate\ducmd.exe"
$logging 			= $false
$logDir 			= $scriptPath + "\" + $ScriptName

# ---------------------------------------------------------------------------
# logging 
# ---------------------------------------------------------------------------
# start logging
if($logging)
{ 
    Start-Transcript "$logDir\$ScriptName.log" 
}

# ---------------------------------------------------------------------------
# main program starts here
# ---------------------------------------------------------------------------
# check for Deskupdate
if (! (Test-Path $DUCMD) ) 
{
    Write-Host "Deskupdate not found" -ForegroundColor Red
    exit 99 
}
else
{
    # run command and save the output
	$return = (cmd /c $DUCMD' /WEB /LIST' | findstr "Driver Application Windows")
    
    # if success, next step
    if ($LASTEXITCODE -eq 0) 
    {
        # check for each part
        $return | % {
            if( $_ -match "Driver" )
            {
                # if driver part has not zero updates
				if ($_[0] -ne "0")
                {
                    $RETURN_MESSAGE += $_.Substring(0, $_.Length-1) + ";"
                    $UPDATE_REQUIRED = $true
                }
            }
            elseif($_ -match "Application")
            {
                # if applications part has not zero updates
				if ($_[0] -ne "0")
                {
                    $RETURN_MESSAGE += $_.Substring(0, $_.Length-1) + ";"
                    $UPDATE_REQUIRED = $true
                }
            }
            elseif($_ -match "Windows")
            {
                # if windows updates part has not zero updates
				if ($_[0] -ne "0")
                {
                    $RETURN_MESSAGE += $_.Substring(0, $_.Length-1) + ";"
                    $UPDATE_REQUIRED = $true
                }
            }
        }
		# if any update was found
        if ($UPDATE_REQUIRED) 
        {
            Write-Host $RETURN_MESSAGE
            if($logging)
			{ 
				Stop-Transcript
			}
			exit 1
        }
		# if no update was found
        else
        {
            if($logging)
			{ 
				Stop-Transcript
			}
			exit 0
        }
    }
	# we had an error with ducmd.exe
    else 
    {
        if($logging)
		{ 
			Stop-Transcript
		}
		exit $LASTEXITCODE
    }
}